// graphDlg.cpp : implementation file
//

#include "stdafx.h"
#include "graph.h"
#include "graphDlg.h"
#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define COL 300
#define COL2 10

int XMIN = 0, YMIN = 0, XMAX, YMAX, XCENTER, YCENTER;
int X[COL], Y[COL], XS[COL], R = 3, C[COL];
int XO[COL2], YO[COL2], XOCENTER, YOCENTER ;
double T2, T = 0, DT = 0.01, PDT = 0.002, XL = 2, YL = 2, DXL = 0.01, DYL = 0.01;
double ROX = 80, DRX = 0.1, ROY = 80, DRY = -0.1, DRO[COL2], RO[COL2];
BOOL StartFlag;



/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphDlg dialog

CGraphDlg::CGraphDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGraphDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGraphDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CGraphDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGraphDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGraphDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_WM_SIZE()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphDlg message handlers

BOOL CGraphDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CGraphDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGraphDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{

			CClientDC dc( this );
	CPen br;

	CBitmap bit;
	CDC dc2;

	bit.CreateCompatibleBitmap( &dc, XMAX, YMAX );

		dc2.CreateCompatibleDC(&dc);
		dc2.SelectObject( &bit );

	    int temp; 
	    dc2.FillSolidRect( 0, 0, XMAX, YMAX, RGB( 0,0,0) );
		
	
		for( int i = 0; i < COL; i++ )
		{
			dc2.SetPixel( X[i], Y[i], RGB( C[i],C[i],C[i] ));
		}
	
		for( i = 0; i < COL2; i++ )
		{
			temp = 255 / COL2;

				br.CreatePen(PS_SOLID, (int)RO[i], RGB( i*temp, i*temp, i*temp) );
				dc2.SelectObject( &br );

			
				dc2.Ellipse( XO[i] - int(RO[i]/2) , YO[i] - int(RO[i]/2) , 
					XO[i] + int(RO[i]/2) , YO[i] + int(RO[i]/2) );
		
		}
     dc.BitBlt( XMIN, YMIN , XMAX, YMAX , &dc2, 0,0, SRCCOPY );
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGraphDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CGraphDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	XMAX = cx - 100;
	YMAX = cy;
	// TODO: Add your message handler code here
	
}

void CGraphDlg::SetBeginPosition()
{
   srand( (unsigned)time( NULL ) );
    XCENTER = XMAX / 2;
	YCENTER = YMAX / 2;

	for( int i=0; i<COL; i++ )
	{
		X[i] =  int((float)rand() / RAND_MAX * XMAX);
		Y[i] =  int((float)rand() / RAND_MAX * YMAX);
		XS[i] = int((float)rand() / RAND_MAX * 3);
		C[i] = int((float)rand() / RAND_MAX * 255);
	}
	int temp = 60 / COL2;
	for( i=0; i<COL2; i++ )
	{
		RO[i] = i*temp;
		DRO[i] = 0.1;
	}

}

void CGraphDlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here

	SetBeginPosition();
 

SetTimer( 1, 100, NULL );
}


void CGraphDlg::Start()
{

	CClientDC dc( this );
	CPen br;

	CBitmap bit;
	CDC dc2;

	bit.CreateCompatibleBitmap( &dc, XMAX, YMAX );

		dc2.CreateCompatibleDC(&dc);
		dc2.SelectObject( &bit );

	    int temp; 
	    dc2.FillSolidRect( 0, 0, XMAX, YMAX, RGB( 0,0,0) );
		
	
		for( int i = 0; i < COL; i++ )
		{
			dc2.SetPixel( X[i], Y[i], RGB( C[i],C[i],C[i] ));
		}
	
		for( i = 0; i < COL2; i++ )
		{
			temp = 255 / COL2;

				br.CreatePen(PS_SOLID, (int)RO[i], RGB( i*temp, i*temp, i*temp) );
				dc2.SelectObject( &br );

			
				dc2.Ellipse( XO[i] - int(RO[i]/2) , YO[i] - int(RO[i]/2) , 
					XO[i] + int(RO[i]/2) , YO[i] + int(RO[i]/2) );
		
		}
     dc.BitBlt( XMIN, YMIN , XMAX, YMAX , &dc2, 0,0, SRCCOPY );
}

void CGraphDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	for( int i=0; i<COL; i++ )
	{
		X[i] += XS[i];
		if( X[i] > XMAX ) X[i] -= XMAX;
	}


	XL += DXL;
	YL += DYL;
	if( (XL >= 3) || (XL <= 1) ) DXL=-DXL;
    if( (YL >= 3) || (XL <= 1) ) DYL=-DYL;

	XOCENTER = XCENTER + int(sin(cos(T2)) * 50);
	YOCENTER = YCENTER + int(cos(T2) * 50);

    ROX += DRX;
    ROY += DRY;

	if( ROX < 30 || ROX > 120 ) DRX = - DRX;
	if( ROY < 30 || ROY > 120 ) DRY = - DRY;

	for( i = 0; i < COL2; i++ )
	{
		XO[i] = XOCENTER + int(sin( (double)i/XL + T) * ROX);
	    YO[i] = YOCENTER + int(cos( (double)i/YL + T) * ROY);
		RO[i] += DRO[i];
		if( RO[i] < 5 || RO[i] >= 60 ) DRO[i]=-DRO[i];
	}

	T2+=0.01;
	T+=DT;
	DT+=PDT;
	if( (DT > 0.2) || (DT < -0.2) ) PDT = -PDT;
	Start();
	CDialog::OnTimer(nIDEvent);
}

void CAboutDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	KillTimer( 1 );
}
